/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.python.google.common.base.Objects;
import org.python.google.common.collect.ForwardingCollection;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.Multisets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public abstract class ForwardingMultiset<E>
extends ForwardingCollection<E>
implements Multiset<E> {
    protected ForwardingMultiset() {
    }

    @Override
    protected abstract Multiset<E> delegate();

    @Override
    public int count(Object object) {
        return this.delegate().count(object);
    }

    @Override
    public int add(E e, int n) {
        return this.delegate().add(e, n);
    }

    @Override
    public int remove(Object object, int n) {
        return this.delegate().remove(object, n);
    }

    @Override
    public Set<E> elementSet() {
        return this.delegate().elementSet();
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        return this.delegate().entrySet();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this || ((Object)this.delegate()).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate()).hashCode();
    }

    @Override
    public int setCount(E e, int n) {
        return this.delegate().setCount(e, n);
    }

    @Override
    public boolean setCount(E e, int n, int n2) {
        return this.delegate().setCount(e, n, n2);
    }

    @Override
    @Beta
    protected boolean standardContains(@Nullable Object object) {
        return this.count(object) > 0;
    }

    @Override
    @Beta
    protected void standardClear() {
        Iterator<Multiset.Entry<E>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Beta
    protected int standardCount(@Nullable Object object) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            if (!Objects.equal(entry.getElement(), object)) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Beta
    protected boolean standardAdd(E e) {
        this.add(e, 1);
        return true;
    }

    @Override
    @Beta
    protected boolean standardAddAll(Collection<? extends E> collection) {
        return Multisets.addAllImpl(this, collection);
    }

    @Override
    @Beta
    protected boolean standardRemove(Object object) {
        return this.remove(object, 1) > 0;
    }

    @Override
    @Beta
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Multisets.removeAllImpl(this, collection);
    }

    @Override
    @Beta
    protected boolean standardRetainAll(Collection<?> collection) {
        return Multisets.retainAllImpl(this, collection);
    }

    @Beta
    protected int standardSetCount(E e, int n) {
        return Multisets.setCountImpl(this, e, n);
    }

    @Beta
    protected boolean standardSetCount(E e, int n, int n2) {
        return Multisets.setCountImpl(this, e, n, n2);
    }

    @Beta
    protected Set<E> standardElementSet() {
        return Multisets.elementSetImpl(this);
    }

    @Beta
    protected Iterator<E> standardIterator() {
        return Multisets.iteratorImpl(this);
    }

    @Beta
    protected int standardSize() {
        return Multisets.sizeImpl(this);
    }

    @Beta
    protected boolean standardEquals(@Nullable Object object) {
        return Multisets.equalsImpl(this, object);
    }

    @Beta
    protected int standardHashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    @Beta
    protected String standardToString() {
        return this.entrySet().toString();
    }
}

